/* Copyright (C) 2015-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef AUTOPTRQUEUE_H_c944110c_51b3_4b64_a26c_49efed8d448b
#define AUTOPTRQUEUE_H_c944110c_51b3_4b64_a26c_49efed8d448b

#include <vnccommon/StaticUtils.h>

#include <deque>
#include <memory>
#include <stdexcept>

/**
 * \cond VNCCOMMON
 */
namespace vnccommon
{

template<typename T>
class AutoPtrQueue
{
    VNCCOMMON_DISALLOW_COPYING(AutoPtrQueue)

public:
    AutoPtrQueue()
    {
    }

    void push(std::auto_ptr<T> value)
    {
        if (!value.get())
        {
          throw std::logic_error("Attempt to insert an empty value");
        }

        mQueue.push_back(value.get());
        value.release();
    }

    bool isEmpty() const
    {
        return mQueue.empty();
    }

    std::auto_ptr<T> pop()
    {
        if(isEmpty())
        {
            throw std::logic_error("Attempt to pop from an empty queue");
        }

        std::auto_ptr<T> result(mQueue.front());
        mQueue.pop_front();
        return result;
    }

    const T& peek() const
    {
        if(isEmpty())
        {
            throw std::logic_error("Attempt to peek in an empty queue");
        }

        return *mQueue.front();
    }

    void takeAllFrom(AutoPtrQueue<T>& o)
    {
        while(!o.isEmpty())
        {
            push(o.pop());
        }
    }

    void clear()
    {
      while(!isEmpty())
      {
          pop();
      }
    }

    size_t size() const
    {
        return mQueue.size();
    }

    ~AutoPtrQueue()
    {
      clear();
    }

private:
    std::deque<T*> mQueue;
};

} // end of namespace vnccommon
/**
 * \endcond VNCCOMMON
 */

#endif // AUTOPTRQUEUE_H_c944110c_51b3_4b64_a26c_49efed8d448b

